
require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'

describe '[Story VARUT-386: Utility - Authentication, VA Tool Set - Home Page]
         [Story VARUT-403: View VAR Utility on Home Page]
         [Story VARUT-717: Remove Home icon on VA Tool Set Home page]
         [Story VARUT-1231: VATS - About Page]'do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-657|TC#VARUT-525: Validate display of VA Tool Set Home Page' do

    it "Login screen" do
      @vts_po.loginLogout.login(UserAccess7)
    end

    it "Verify App Title" do
      @vts_po.common.waitWhileSpinnerPresent
      @vts_po.home.title_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.title_element.text).to eq("VA Tool Set")
    end

    it "Verify Home page - Details" do
      @vts_po.home.primary_header_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.primary_header).to eq("Home")
      homeWelcomeMessage = @vts_po.home.home_welcome_message.split("\n")
      expect(homeWelcomeMessage[0]).to eq("Welcome SEVEN PROVIDER")
      @vts_po.home.sectionLabel_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.sectionLabel_element.text).to eq("Tools")
    end

    it "Verify Footer Details" do
      @vts_po.home.leftFooter_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.leftFooter).to eq("VA Tool Set - v2.3.0")
      @vts_po.home.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.rightFooter).to eq("Logged in as PROVIDER, SEVEN")
    end

  end

  context 'TC#VARUT-812: Remove Home icon on VA Tool Set Home page' do

    it "Verify Home icon is removed on VA Tool Set Home page" do
      expect(@vts_po.home.home_btn_element.visible?).to eq(false)
    end

  end

  context 'AC#VARUT-640|TC#VARUT-643 : Validate VAR Utility on Home Page' do

    it "Verify VAR Utility icon and texts on Home Page" do
      @vts_po.home.varUtilImg_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.varUtilImg_element.present?).to eq(true)
      @vts_po.home.varUtilTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.varUtilTitle_element.text).to eq("VAR Utility")
      @vts_po.home.varUtilText1_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.varUtilText1_element.text).to eq("The VAR Utility allows users to manage the VA Health Care facility appointment and request offerings available in the VAR Appointment app.")
      @vts_po.home.varUtilText2_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.varUtilText2_element.text).to eq("Valid facility login credentials are required to use this tool.")
      @vts_po.home.varUtilOpen_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.home.varUtilOpen_element.text).to eq("Open")
    end

  end
end




